//*************+***************+***************+***************+***************+
//
//	SEKONIC
//	Device control Error code header
//
//	FileName	: SkDvSrSeriesErr.h
//	CPU			: x86
//	Compiler	: Microsoft Visual C++ 6.0 or later
//
//*************+***************+***************+***************+***************+
//	2012.01.11	Into English
//	2011.10.27	for SR-3500 HYBRID
//*************+***************+***************+***************+***************+
#ifndef	INCLUDE_SKDVSR3500ERR_HEADER			// Multi include of a header is prevented.
#define	INCLUDE_SKDVSR3500ERR_HEADER

#pragma once


#include "SkCommIoErr.h"


//*************+***************+***************+***************+***************+
//	define / typedef
//*************+***************+***************+***************+***************+

//-----+-------+-------+-------+-------+-------+-------+-------+
// Status info (SkDvStatus)
#define	SKDV_STS_MODULE_MASK					0xffff0000		// Bit mask of Module definition sector
#define	SKDV_STS_MODULE							0x20310000		// This module
#define	SKDV_STS_MODULE_IO						0x20210000		// The lower basic communication library
#define	SKDV_STS_DEVICE_ERR						0x20020000		// Error from Device


//-----+-------+-------+-------+-------+-------+-------+-------+
#define	SKDV_STS_SUCCESS						0x00000000		// Success

#define	SKDV_STS_EXECUTE_ERR					0x20310001		// WindowAPI Execution error
#define	SKDV_STS_CREATE_EVENT_ERR				0x20310006		// Create Event Error
#define	SKDV_STS_CREATE_THREAD_ERR				0x20310007		// Create Thread Error
#define	SKDV_STS_USED_DEVICE					0x2031000E		// Device is in used
#define	SKDV_STS_WAIT_TIMEOUT					0x2031000F		// Timeout

#define	SKDV_STS_HANDLE_ERR						0x20311001		// Handle Error
#define	SKDV_STS_MEM_ALLOC_ERR					0x20311002		// Memory Allocation Error
#define	SKDV_STS_LOAD_SUBLIB_ERR				0x20311003		// Load Sub library Error

#define	SKDV_STS_PARAM_ERR						0x20311010		// Parameter Incorrect
#define	SKDV_STS_PARAM_ERR1						0x20311011		// Parameter 1 Incorrect
#define	SKDV_STS_PARAM_ERR2						0x20311012		// Parameter 2 Incorrect
#define	SKDV_STS_PARAM_ERR3						0x20311013		// Parameter 3 Incorrect
#define	SKDV_STS_PARAM_ERR4						0x20311014		// Parameter 4 Incorrect
#define	SKDV_STS_PARAM_ERR5						0x20311015		// Parameter 5 Incorrect
#define	SKDV_STS_PARAM_ERR6						0x20311016		// Parameter 6 Incorrect
#define	SKDV_STS_PARAM_ERR7						0x20311017		// Parameter 7 Incorrect
#define	SKDV_STS_PARAM_ERR8						0x20311018		// Parameter 8 Incorrect
#define	SKDV_STS_PARAM_ERR9						0x20311019		// Parameter 9 Incorrect
#define	SKDV_STS_FUNCTION_ERR					0x2031101F		// API Function Error

#define	SKDV_STS_PARAM_ERR_SCANNINGSIDE			0x20311011		// Parameter Error Back side scanning
#define	SKDV_STS_PARAM_ERR_SCAN_CTRL			0x20311012		// Parameter Error Scanning Control
//	#define	SKDV_STS_PARAM_ERR_FEED_CTRL			0x20311013		// (Reserved)Parameter Error Feed Control
//	#define	SKDV_STS_PARAM_ERR_THICKNESS			0x20311014		// (Reserved)Parameter Error Thickness
#define	SKDV_STS_PARAM_ERR_FORMLENGTH_MAX		0x20311014		// Parameter Error MAX Form Length
#define	SKDV_STS_PARAM_ERR_FORMLENGTH_MIN		0x20311015		// Parameter Error MIN Form Length
#define	SKDV_STS_PARAM_ERR_CIS_LIGHT			0x20311016		// CIS Light Incorrect(+iFace)
#define	SKDV_STS_PARAM_ERR_CIS_LIGHT_F			0x20311016		// CIS Light Incorrect (F)
#define	SKDV_STS_PARAM_ERR_CIS_LIGHT_B			0x20311017		// CIS Light Incorrect(B)
#define	SKDV_STS_PARAM_ERR_RESOLUTION			0x20311018		// Resolution Incorrect
//	#define	SKDV_STS_PARAM_ERR_RESOLUTION_V			0x20311019		// (Reserved)Resolution Incorrect

//	#define	SKDV_STS_INTERFACE_ERR					0x20311020		// (Reserved)Interface error
#define SKDV_STS_CIS_BASE_DATA_ERR				0x20311021		// CIS Base data Incorrect

#define SKDV_STS_NO_DATA						0x20311100		// No Data
//	#define SKDV_STS_ADJ_SHADE_ERR					0x20311101		// (Reserved)
#define SKDV_STS_ROTATION_ERR					0x20311102		// Rotation Error

#define SKDV_STS_IMAGE_PROCESS_ERR				0x203111ff		// Image Process Error

#define	SKDV_STS_FILE_ERR						0x20311200		// File Error
#define	SKDV_STS_FILE_SAVE_ERR					0x20311201		// File Save Error
#define	SKDV_STS_FILE_LOAD_ERR					0x20311211		// File Load Error
#define	SKDV_STS_FILE_FORMAT_ERR				0x20311231		// File Format Error

//	#define SKDV_STS_DV_IMAGE_ERR				0x2031130X		// Image data error (from OMR device)
#define SKDV_STS_DV_IMAGE_ERR					0x20311301		// Failure image data Transfer (from OMR device)
//	#define SKDV_STS_DV_IMAGE_SHORTAGE				0x20311301		// (Reserved)
//	#define SKDV_STS_DV_IMAGE_OVER_LEN				0x20311302		// (Reserved)
//	#define SKDV_STS_DV_IMAGE_ERR_UNKNOWN			0x2031130F		// (Reserved)

//	#define SKDV_STS_IMAGE_DATA_ERR				0x2031131X		// Image Data error
#define SKDV_STS_NO_IMAGE						0x20311311		// No Image
#define SKDV_STS_OVER_LENGTH_IMAGE				0x20311312		// Image data Overloaded
#define SKDV_STS_DIFF_IMAGE_WIDTH				0x20311313		// Image Width Different
#define SKDV_STS_DIFF_IMAGE_HEIGHT				0x20311314		// Image Height different
#define SKDV_STS_IMAGE_LENGTH_ERR				0x20311315		// Image Length Error

//	#define	SKDV_STS_RECVED_NAK					0x2031210X		// NAKreceived
#define	SKDV_STS_RECVED_NAK_CMD					0x20312101		// NAKreceived (Command Error)
#define	SKDV_STS_RECVED_NAK_PRM					0x20312102		// NAKreceived (Parameter Error)
#define	SKDV_STS_RECVED_NAK_NON					0x20312103		// NAKreceived (Non Support)
#define	SKDV_STS_RECVED_NAK_OPE					0x20312104		// NAKreceived (LCD panel operation)
#define	SKDV_STS_RECVED_NAK_DOING				0x20312105		// NAKreceived (Operating unit)
#define	SKDV_STS_RECVED_NAK_UNKNOWN				0x2031210F		// NAKreceived (Unknown)

#define	SKDV_STS_RECV_ACK_TIMEOUT				0x20312200		// Timeout (ACKreceived)
#define	SKDV_STS_RECV_RES_TIMEOUT				0x20312201		// Timeout (Response received)
#define	SKDV_STS_DIFF_ACK_CMD					0x20312210		// CMD code of ACK is Different
#define	SKDV_STS_DIFF_RES_CMD					0x20312211		// CMD code of response is Different
#define	SKDV_STS_SHORT_RESPONSE_ERR				0x20312220		// The length of response is short
#define	SKDV_STS_LONG_RESPONSE_ERR				0x20312221		// The length of response is long
#define	SKDV_STS_RESPONSE_FORMAT_ERR			0x20312222		// Incorrect response format
#define	SKDV_STS_DIFF_PRM						0x20312223		// Different Parameter

//	#define	SKDV_STS_CALIB						0x203130XX		// Calibration Error
#define	SKDV_STS_CALIB							0x20313000		// Calibration Error
#define	SKDV_STS_CALIB_MASK						0xffffff00		// Bit mask of Calibration Error
																// Backgraund check
#define	SKDV_STS_CALIB_CHK_BG_EVEN_BL_F_ERR		0x20313010		// Different the data when LED off (Front)
#define	SKDV_STS_CALIB_CHK_BG_EVEN_BL_B_ERR		0x20313011		// Different the data when LED off (Back)
#define	SKDV_STS_CALIB_CHK_BG_EVEN_WH_F_ERR		0x20313012		// Different the data when LED On (Front)
#define	SKDV_STS_CALIB_CHK_BG_EVEN_WH_B_ERR		0x20313013		// Different the data when LED On (Back)
#define	SKDV_STS_CALIB_CHK_BG_DIFF_F_ERR		0x20313014		// Gap is big between LED ON / OFF (Front)
#define	SKDV_STS_CALIB_CHK_BG_DIFF_B_ERR		0x20313015		// Gap is big between LED ON / OFF (Back)
																// CIS base level check(scattering)
#define	SKDV_STS_CALIB_CIS_BS_BLACK_EVEN_F_ERR	0x20313020		// Difference Black Level (Front)
#define	SKDV_STS_CALIB_CIS_BS_BLACK_EVEN_B_ERR	0x20313021		// Difference Black Level (Back)
#define	SKDV_STS_CALIB_CIS_BS_WHITE_EVEN_F_ERR	0x20313022		// Difference White Level (Front)
#define	SKDV_STS_CALIB_CIS_BS_WHITE_EVEN_B_ERR	0x20313023		// Difference White Level (Back)
#define	SKDV_STS_CALIB_CIS_BS_RED_EVEN_F_ERR	0x20313024		// Difference Red Level (Front)
#define	SKDV_STS_CALIB_CIS_BS_RED_EVEN_B_ERR	0x20313025		// Difference Red Level (Back)
#define	SKDV_STS_CALIB_CIS_BS_GREEN_EVEN_F_ERR	0x20313026		// Difference Green Level (Front)
#define	SKDV_STS_CALIB_CIS_BS_GREEN_EVEN_B_ERR	0x20313027		// Difference Green Level (Back)
#define	SKDV_STS_CALIB_CIS_BS_BLUE_EVEN_F_ERR	0x20313028		// Difference Blue Level (Front)
#define	SKDV_STS_CALIB_CIS_BS_BLUE_EVEN_B_ERR	0x20313029		// Difference Blue Level (Back)
																// CIS base level check(value)
#define	SKDV_STS_CALIB_CIS_BS_BLACK_UPPER_F_ERR	0x20313030		// Black Level Max (Front)
#define	SKDV_STS_CALIB_CIS_BS_BLACK_UPPER_B_ERR	0x20313031		// Black Level Max (Back)
#define	SKDV_STS_CALIB_CIS_BS_WHITE_RANGE_F_ERR	0x20313032		// White Level calibration Range (Front)
#define	SKDV_STS_CALIB_CIS_BS_WHITE_RANGE_B_ERR	0x20313033		// White Level Calibration Range (Back)
#define	SKDV_STS_CALIB_CIS_BS_RED_RANGE_F_ERR	0x20313034		// Red Level calibration Range (Front)
#define	SKDV_STS_CALIB_CIS_BS_RED_RANGE_B_ERR	0x20313035		// Red Level calibration Range (Back)
#define	SKDV_STS_CALIB_CIS_BS_GREEN_RANGE_F_ERR	0x20313036		// Green Level calibration Range (Front)
#define	SKDV_STS_CALIB_CIS_BS_GREEN_RANGE_B_ERR	0x20313037		// Green Level calibration Range (Back)
#define	SKDV_STS_CALIB_CIS_BS_BLUE_RANGE_F_ERR	0x20313038		// Blue Level calibration Range (Front)
#define	SKDV_STS_CALIB_CIS_BS_BLUE_RANGE_B_ERR	0x20313039		// Blue Level calibration Range (Back)
																// Platen check
#define	SKDV_STS_CALIB_CHK_PL_UPPER_F_ERR		0x20313040		// Platen detects too White (Front)
#define	SKDV_STS_CALIB_CHK_PL_UPPER_B_ERR		0x20313041		// Platen detects too White (Back)

//	#define	SKDV_STS_CALIB_LEFTSKEW				0x203131XX		// Left Skew Level Calibration Error
#define	SKDV_STS_CALIB_LS_UPPER_LEVEL_ERR		0x20313101		// Left Skew Level High
#define	SKDV_STS_CALIB_LS_UNDER_LEVEL_ERR		0x20313102		// Left Skew Level Low


//	#define	SKDV_STS_USER						0x2031fXXX		// User operation
#define	SKDV_STS_USER_CANCEL					0x2031f001		// User Cancel


//-----+-------+-------+-------+-------+-------+-------+-------+
// SR-Series
//-----+-------+-------+-------+-------+-------+-------+-------+
#define	SKDV_STS_DEVICE_ST_MASK					0xfffff800		// Bit mask of status code from the device
#define	SKDV_STS_DEVICE_STA_MASK				0xffffff80		// Bit mask of status code from the device
#define	SKDV_STS_DEVICE_FACE_MASK				0x00000060		// Bit mask of information from the device front and back
#define	SKDV_STS_DEVICE_DIF_MASK				0x0000001f		// Bit mask for detailed information from the device

//-----+-------+-------+-------+-------+-------+-------+-------+
//												0xffffff80		// Bit mask of status code from the device
															// "A*"Main unit
#define	SKDV_STS_DEVICE_ST_A1					0x20020880		// "A1"Memory Error 1 (Internal Memory Error)
#define	SKDV_STS_DEVICE_ST_A2					0x20020900		// "A2"Memory Error 2 (Internal Memory Error)
#define	SKDV_STS_DEVICE_ST_A3					0x20020980		// "A3"Hopper Drive Error
#define	SKDV_STS_DEVICE_ST_A4					0x20020A00		// "A4"Download Error (Main Unit)
#define	SKDV_STS_DEVICE_ST_A5					0x20020A80		// "A5"Sensor Type Error
#define	SKDV_STS_DEVICE_ST_A6					0x20020B00		// "A6"Option Error
#define	SKDV_STS_DEVICE_ST_A8					0x20020C00		// "A8"Power Supply Error
															// "B*"Reading unit
#define	SKDV_STS_DEVICE_ST_B1					0x20021080		// "B1"Communication Error
#define	SKDV_STS_DEVICE_ST_B2					0x20021100		// "B2"Internal COM Error (No response Read Sensor)
#define	SKDV_STS_DEVICE_ST_B3					0x20021180		// "B3"Memory Error (in Read Sensor) 
#define	SKDV_STS_DEVICE_ST_B4					0x20021200		// "B4"Adjust Value Error (Read Sensor)
#define	SKDV_STS_DEVICE_ST_B5					0x20021280		// "B5"Download Error (Read Sensor)  
#define	SKDV_STS_DEVICE_ST_B6					0x20021300		// "B6"Internal Error (Read Sensor)
#define	SKDV_STS_DEVICE_ST_B7					0x20021380		// "B7"Version Error(Read Sensor) 
															// "C*"Barcode unit
#define	SKDV_STS_DEVICE_ST_C1					0x20021880		// "C1"Communication Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C2					0x20021900		// "C2"Internal COM Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C3					0x20021980		// "C3"Memory Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C4					0x20021A00		// "C4"Sensor Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C5					0x20021A80		// "C5"Download Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C6					0x20021B00		// "C6"Internal Error (Barcode Unit)
#define	SKDV_STS_DEVICE_ST_C7					0x20021B80		// "C7"Version Error (Barcode Unit)
															// "D*"Printer unit
#define	SKDV_STS_DEVICE_ST_D1					0x20022080		// "D1"Communication Error(Printer Unit)
#define	SKDV_STS_DEVICE_ST_D2					0x20022100		// "D2"Internal COM Error (Printer Unit)
#define	SKDV_STS_DEVICE_ST_D3					0x20022180		// "D3"Memory Error (Printer Unit)
#define	SKDV_STS_DEVICE_ST_D4					0x20022200		// "D4"Download Error (Printer Unit)
#define	SKDV_STS_DEVICE_ST_D5					0x20022280		// "D5"Internal Error (Printer Unit)
#define	SKDV_STS_DEVICE_ST_D6					0x20022300		// "D6"Version Error (Printer Unit)
															// "E*"Stacker unit
#define	SKDV_STS_DEVICE_ST_E1					0x20022880		// "E1"Communication Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E2					0x20022900		// "E2"Internal COM Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E3					0x20022980		// "E3"Memory Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E4					0x20022A00		// "E4"Download Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E5					0x20022A80		// "E5"Internal Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E6					0x20022B00		// "E6"Version Error (Stacker Unit)
#define	SKDV_STS_DEVICE_ST_E7					0x20022B80		// "E7"Drive Error (Stacker Unit)
															// "J*"Image reading unit
#define	SKDV_STS_DEVICE_ST_J1					0x20025080		// "J1"Download Error (Image Sensor Unit) 
#define	SKDV_STS_DEVICE_ST_J2					0x20025100		// "J2"Internal COM Error 1 (Image Sensor Unit)
#define	SKDV_STS_DEVICE_ST_J3					0x20025180		// "J3"Internal COM Error 1 (Image Sensor Unit)
#define	SKDV_STS_DEVICE_ST_J4					0x20025200		// "J4"Memory Error 1 (Image Sensor Unit / Flash Rom Read Error) 
#define	SKDV_STS_DEVICE_ST_J5					0x20025280		// "J5"Memory Error 2 (Image Sensor Unit / Flash Rom Load Error)  
#define	SKDV_STS_DEVICE_ST_J6					0x20025300		// "J6"Memory Error 3 (Image Sensor Unit / E2PROM Read Error)
#define	SKDV_STS_DEVICE_ST_J7					0x20025380		// "J7"Memory Error 4 (Image Sensor Unit / E2PROM Load Error) 
#define	SKDV_STS_DEVICE_ST_J8					0x20025400		// "J8"IC Error (Image Sensor Unit)
#define	SKDV_STS_DEVICE_ST_J9					0x20025480		// "J9"CIS Error (Image Sensor Unit)
#define	SKDV_STS_DEVICE_ST_K1					0x20025880		// "K1"FPGA Error (Image Sensor Unit) 
#define	SKDV_STS_DEVICE_ST_K2					0x20025900		// "K2"Power Supply Error (Image Sensor Unit) 
#define	SKDV_STS_DEVICE_ST_K3					0x20025980		// "K3"Version Error (Image Sensor Unit) 
															// "F*"Communication error
#define	SKDV_STS_DEVICE_ST_F5					0x20023280		// "F5"Command Error
#define	SKDV_STS_DEVICE_ST_F6					0x20023300		// "F6"Parameter Error
#define	SKDV_STS_DEVICE_ST_F7					0x20023380		// "F7"Protocol Error
															// "G*"Cover open
#define	SKDV_STS_DEVICE_ST_G1					0x20023880		// "G1"Cover Open 
#define	SKDV_STS_DEVICE_ST_G2					0x20023900		// "G2"Stacker Unit Cover Open
															// "H*"Jam
#define	SKDV_STS_DEVICE_ST_H1					0x20024080		// "H1"No Feed
#define	SKDV_STS_DEVICE_ST_H2					0x20024100		// "H2"Jam at Paper Feeding Detection Sensor 
#define	SKDV_STS_DEVICE_ST_H3					0x20024180		// "H3"Jam at Reading Start Detection Sensor 
#define	SKDV_STS_DEVICE_ST_H4					0x20024200		// "H4"Jam at Main body Paper Discharge Detection Sensor
#define	SKDV_STS_DEVICE_ST_H5					0x20024280		// "H5"Too few Paper gap
															// "I*"Stacker unit Jam
#define	SKDV_STS_DEVICE_ST_I1					0x20024880		// "I1"Jam at Printing Start Detection Sensor
#define	SKDV_STS_DEVICE_ST_I2					0x20024900		// "I2"Jam at Main Paper Discharge Sensor
#define	SKDV_STS_DEVICE_ST_I3					0x20024980		// "I3"Jam at Selected (Reject) Paper Discharge Sensor
#define	SKDV_STS_DEVICE_ST_I4					0x20024A00		// "I4"Jam at Upper part Paper Detection Sensors
#define	SKDV_STS_DEVICE_ST_I5					0x20024A80		// "I5"Jam at Bottom part Paper Detection Sensors
#define	SKDV_STS_DEVICE_ST_I6					0x20024B00		// "I6"Too few Paper gap
															// "P*"
#define	SKDV_STS_DEVICE_ST_P1					0x20028080		// "P1"Back Surface Reading Unit Unconnected
#define	SKDV_STS_DEVICE_ST_P2					0x20028100		// "P2"Barcode Unit Unconnected
#define	SKDV_STS_DEVICE_ST_P3					0x20028180		// "P3"Printer Unit Unconnected
#define	SKDV_STS_DEVICE_ST_P4					0x20028200		// "P4"Select Stacker Unit Unconnected
#define	SKDV_STS_DEVICE_ST_P5					0x20028280		// "P5"Image Sensor Unit Unconnected
															// "Q*"
#define	SKDV_STS_DEVICE_ST_Q1					0x20028880		// "Q1"Sheet Empty
#define	SKDV_STS_DEVICE_ST_Q2					0x20028900		// "Q2"Double Feed Error
#define	SKDV_STS_DEVICE_ST_Q3					0x20028980		// "Q3"Left End Skew Error
#define	SKDV_STS_DEVICE_ST_Q4					0x20028A00		// "Q4"Mark Skew Error
															// "R*"
#define	SKDV_STS_DEVICE_ST_R1					0x20029080		// "R1"Hopper Stops
#define	SKDV_STS_DEVICE_ST_R2					0x20029100		// "R2"Drowing Out Error
#define	SKDV_STS_DEVICE_ST_R3					0x20029180		// "R3"Timeout
#define	SKDV_STS_DEVICE_ST_R4					0x20029200		// "R4"Timing Mark Error
#define	SKDV_STS_DEVICE_ST_R5					0x20029280		// "R5"Setting Error
#define	SKDV_STS_DEVICE_ST_R6					0x20029300		// "R6"Memory Overflow
#define	SKDV_STS_DEVICE_ST_R7					0x20029380		// "R7"USB Connection Error
#define	SKDV_STS_DEVICE_ST_R8					0x20029400		// "R8"
															// "S*"
#define	SKDV_STS_DEVICE_ST_S2					0x20029900		// "S2"Black Level Error
#define	SKDV_STS_DEVICE_ST_S3					0x20029980		// "S3"Read Sensor Stain Error
#define	SKDV_STS_DEVICE_ST_S4					0x20029A00		// "S4"Paper feeding Sensor Stain Error
															// "T*"
#define	SKDV_STS_DEVICE_ST_T1					0x2002A080		// "T1"Form Left In Hopper
#define	SKDV_STS_DEVICE_ST_T2					0x2002A100		// "T2"Form Left in Reading Sensor
#define	SKDV_STS_DEVICE_ST_T3					0x2002A180		// "T3"Form Left in End of Main Body
#define	SKDV_STS_DEVICE_ST_T4					0x2002A200		// "T4"Form Left in Printer Printing Detection Sensor
#define	SKDV_STS_DEVICE_ST_T5					0x2002A280		// "T5"Form Left in Main paper Discharge Sensor
#define	SKDV_STS_DEVICE_ST_T6					0x2002A300		// "T6"Form Left in Selected (Reject) Paper Discharge Sensor
															// "Z*"
#define	SKDV_STS_DEVICE_ST_Z1					0x2002D080		// "Z1"Density adjust Skew Error
#define	SKDV_STS_DEVICE_ST_Z2					0x2002D100		// "Z2"Density adjust Sheet Error
#define	SKDV_STS_DEVICE_ST_Z3					0x2002D180		// "Z3"Dirt Density adjust Sheet
#define	SKDV_STS_DEVICE_ST_Z4					0x2002D200		// "Z4"Density adjust Error
#define	SKDV_STS_DEVICE_ST_Z5					0x2002D280		// "Z5"RDPS adjust Error
#define	SKDV_STS_DEVICE_ST_Z6					0x2002D300		// "Z6"Skew Sensor Adjust Error
#define	SKDV_STS_DEVICE_ST_Z7					0x2002D380		// "Z7"DF sensor Adjust Error


//-----+-------+-------+-------+-------+-------+-------+-------+
//												0xfffff800
#define	SKDV_STS_DEVICE_STS1_NONE				0x20020000		// "0*"
#define	SKDV_STS_DEVICE_STS1_A					0x20020800		// "A*"
#define	SKDV_STS_DEVICE_STS1_B					0x20021000		// "B*"
#define	SKDV_STS_DEVICE_STS1_C					0x20021800		// "C*"
#define	SKDV_STS_DEVICE_STS1_D					0x20022000		// "D*"
#define	SKDV_STS_DEVICE_STS1_E					0x20022800		// "E*"
#define	SKDV_STS_DEVICE_STS1_F					0x20023000		// "F*"
#define	SKDV_STS_DEVICE_STS1_G					0x20023800		// "G*"
#define	SKDV_STS_DEVICE_STS1_H					0x20024000		// "H*"
#define	SKDV_STS_DEVICE_STS1_I					0x20024800		// "I*"
#define	SKDV_STS_DEVICE_STS1_J					0x20025000		// "J*"
#define	SKDV_STS_DEVICE_STS1_K					0x20025800		// "K*"
#define	SKDV_STS_DEVICE_STS1_L					0x20026000		// "L*"
#define	SKDV_STS_DEVICE_STS1_M					0x20026800		// "M*"
#define	SKDV_STS_DEVICE_STS1_N					0x20027000		// "N*"
#define	SKDV_STS_DEVICE_STS1_O					0x20027800		// "O*"
#define	SKDV_STS_DEVICE_STS1_P					0x20028000		// "P*"
#define	SKDV_STS_DEVICE_STS1_Q					0x20028800		// "Q*"
#define	SKDV_STS_DEVICE_STS1_R					0x20029000		// "R*"
#define	SKDV_STS_DEVICE_STS1_S					0x20029800		// "S*"
#define	SKDV_STS_DEVICE_STS1_T					0x2002A000		// "T*"
#define	SKDV_STS_DEVICE_STS1_U					0x2002A800		// "U*"
#define	SKDV_STS_DEVICE_STS1_V					0x2002B000		// "V*"
#define	SKDV_STS_DEVICE_STS1_W					0x2002B800		// "W*"
#define	SKDV_STS_DEVICE_STS1_X					0x2002C000		// "X*"
#define	SKDV_STS_DEVICE_STS1_Y					0x2002C800		// "Y*"
#define	SKDV_STS_DEVICE_STS1_Z					0x2002D000		// "Z*"
#define	SKDV_STS_DEVICE_STS1_AT					0x2002F800		// "@*"

//-----+-------+-------+-------+-------+-------+-------+-------+
#define	SKDV_STS_DEVICE_STS2_0					0x00000000		// "*0"
#define	SKDV_STS_DEVICE_STS2_1					0x00000080		// "*1"
#define	SKDV_STS_DEVICE_STS2_2					0x00000100		// "*2"
#define	SKDV_STS_DEVICE_STS2_3					0x00000180		// "*3"
#define	SKDV_STS_DEVICE_STS2_4					0x00000200		// "*4"
#define	SKDV_STS_DEVICE_STS2_5					0x00000280		// "*5"
#define	SKDV_STS_DEVICE_STS2_6					0x00000300		// "*6"
#define	SKDV_STS_DEVICE_STS2_7					0x00000380		// "*7"
#define	SKDV_STS_DEVICE_STS2_8					0x00000400		// "*8"
#define	SKDV_STS_DEVICE_STS2_9					0x00000480		// "*9"
#define	SKDV_STS_DEVICE_STS2_AT					0x00000780		// "*@"

//-----+-------+-------+-------+-------+-------+-------+-------+
//												0x00000060		// Information from side of the device
#define	SKDV_STS_DEVICE_FACE_BOTH				0x00000000		// Both
#define	SKDV_STS_DEVICE_FACE_FRONT				0x00000020		// Front
#define	SKDV_STS_DEVICE_FACE_BACK				0x00000040		// Back
#define	SKDV_STS_DEVICE_FACE_SAME				0x00000060		// Same

//-----+-------+-------+-------+-------+-------+-------+-------+
//												0x0000001f		// More information from the device
#define	SKDV_STS_DEVICE_DIF_NONE				0x00000000		// "0"
#define	SKDV_STS_DEVICE_DIF_A					0x00000001		// "A"
#define	SKDV_STS_DEVICE_DIF_B					0x00000002		// "B"
#define	SKDV_STS_DEVICE_DIF_C					0x00000003		// "C"
#define	SKDV_STS_DEVICE_DIF_D					0x00000004		// "D"
#define	SKDV_STS_DEVICE_DIF_E					0x00000005		// "E"
#define	SKDV_STS_DEVICE_DIF_F					0x00000006		// "F"
#define	SKDV_STS_DEVICE_DIF_G					0x00000007		// "G"
#define	SKDV_STS_DEVICE_DIF_H					0x00000008		// "H"
#define	SKDV_STS_DEVICE_DIF_I					0x00000009		// "I"
#define	SKDV_STS_DEVICE_DIF_J					0x0000000A		// "J"
#define	SKDV_STS_DEVICE_DIF_K					0x0000000B		// "K"
#define	SKDV_STS_DEVICE_DIF_L					0x0000000C		// "L"
#define	SKDV_STS_DEVICE_DIF_M					0x0000000D		// "M"
#define	SKDV_STS_DEVICE_DIF_N					0x0000000E		// "N"
#define	SKDV_STS_DEVICE_DIF_O					0x0000000F		// "O"
#define	SKDV_STS_DEVICE_DIF_P					0x00000010		// "P"
#define	SKDV_STS_DEVICE_DIF_Q					0x00000011		// "Q"
#define	SKDV_STS_DEVICE_DIF_R					0x00000012		// "R"
#define	SKDV_STS_DEVICE_DIF_S					0x00000013		// "S"
#define	SKDV_STS_DEVICE_DIF_T					0x00000014		// "T"
#define	SKDV_STS_DEVICE_DIF_U					0x00000015		// "U"
#define	SKDV_STS_DEVICE_DIF_V					0x00000016		// "V"
#define	SKDV_STS_DEVICE_DIF_W					0x00000017		// "W"
#define	SKDV_STS_DEVICE_DIF_X					0x00000018		// "X"
#define	SKDV_STS_DEVICE_DIF_Y					0x00000019		// "Y"
#define	SKDV_STS_DEVICE_DIF_Z					0x0000001A		// "Z"
#define	SKDV_STS_DEVICE_DIF_AT					0x0000001F		// "@"



//-----+-------+-------+-------+-------+-------+-------+-------+
// Macro

#define	SKDV_IS_DEVICE_ERROR(S)					((SKDV_STS_MODULE_MASK & (S)) == SKDV_STS_DEVICE_ERR)
																// Macro to determine the error of the device

#define	SKDV_IGNORE_DEVICE_ERROR(S)				(((SKDV_STS_MODULE_MASK & (S)) == SKDV_STS_DEVICE_ERR) ? 0 : (S))
																// Macro to ignore the error of the device



#endif											// Multi include of a header is prevented.
